require 'scripts/gui/gui.lua'

--------------------------------------------------------------------------------
-- Menu Object script
--------------------------------------------------------------------------------

-- global instance of menu
g_menu = nil

-- Pages ids
FIRST_MESSAGE_PAGE = 0
MAIN_PAGE = 1
SETTINGS_PAGE = 2
RESTORE_POINT_PAGE = 3

MENU_STATE_IDLE = 0
MENU_STATE_ANIM_OPEN_MENU = 1
MENU_STATE_ANIM_CLOSE_MENU = 2
MENU_STATE_ANIM_OPEN_SETTINGS = 3
MENU_STATE_ANIM_CLOSE_SETTINGS = 4

POPUP_ID_FIRST_MESSAGE = 1
POPUP_ID_LOAD_FROM_RESTORE_MESSAGE = 2

-- isFirstLaunch = true
	
-- VC_isFirstLaunch = function()
-- 	local b = isFirstLaunch
-- 	isFirstLaunch = false
-- 	return true
-- end

VCMenus = class()

-- Callback when object is added to the world
function VCMenus:start()

	g_menu = self
	
	GUI:reset()
	GUI.focusedElement = nil
	GUI:setInputCamera(self.camera_touch, 854, 480)
	
	self.main_page_script = WorldNode_getScriptComponent(self.main_page, "MainPage")
	
	self.settings_page_script = WorldNode_getScriptComponent(self.settings_page, "SettingsPage")
	
	self.occulting_sprite = Component_getNode(self.anim_menu_fadeout)
	
	local year, month, day, hour, minute, second = VC_getSaveStateDate()

	TextVariableManager_setIntVariable("FILE_YEAR", year)
	TextVariableManager_setIntVariable("FILE_MONTH", month)
	TextVariableManager_setIntVariable("FILE_DAY", day)
	TextVariableManager_setIntVariable("FILE_HOUR", hour)
	TextVariableManager_setIntVariable("FILE_MINUTE", minute)
	
	TextVariableManager_setVariable("BUTTON_A", Localization_getText("SYS_BUTTON_A"))
	TextVariableManager_setVariable("BUTTON_B", Localization_getText("SYS_BUTTON_B"))
	TextVariableManager_setVariable("BUTTON_ZR", Localization_getText("SYS_BUTTON_ZR"))
	
	
	self.state = MENU_STATE_IDLE

	self.current_page = MAIN_PAGE

	-- Setup backgrounds
	VC_replaceTexture(self.place_holder_top, 0)
	VC_replaceTexture(self.place_holder_bottom, 1)
	
	VC_replaceTexture(self.save_placeholder_top, 2)
	VC_replaceTexture(self.save_placeholder_bottom, 3)
	
	self:computeBackgroundScreensLayout()
	
	self:applyBackgrounds()
	
	if VC_isFirstLaunch() then
		self:switchPage(FIRST_MESSAGE_PAGE)
		
		WorldNode_setEnabled(WorldNode_getChildByName(self.worldNode, "title_bar"), false)
	elseif VC_isLaunchedFromRestorePoint() then
		
		self:switchPage(RESTORE_POINT_PAGE)
		
		WorldNode_setEnabled(WorldNode_getChildByName(self.worldNode, "title_bar"), false)
	else
		self:switchPage(MAIN_PAGE)
	
		self.settings_page_script:setupLayouts(self.layout_pres)
		
		self:launchAnimation(self.anim_open_menu, MENU_STATE_ANIM_OPEN_MENU)
		
		VC_playSound(g_menu.sound_open_menu, 1.0)
		
		self:applyScreensFilteringMode()
	end

end

-- Callback when object is removed from the world
function VCMenus:stop()
	GUI:focusElement(nil)
	GUI:reset()
end

-- Callback called every frames
function VCMenus:update(dt)
	
	self.focusedElementAtFrameStart = GUI.focusedElement
	
	GUI:updateInputs(dt)

	if self.current_page == FIRST_MESSAGE_PAGE then
		if self.current_dialog.state == POPUP_STATE_IDLE then
			WorldNode_setEnabled(self.current_dialog.persistent_bg, false)
		end
			
	elseif self.current_page == RESTORE_POINT_PAGE then
		
	else
		
		if self.state == MENU_STATE_ANIM_OPEN_MENU then
			if AnimatorComponent_isStopped(self.anim_open_menu) then
				self.main_page_script.is_active = true
				self.state = MENU_STATE_IDLE
			end
		elseif self.state == MENU_STATE_ANIM_CLOSE_MENU then
			if AnimatorComponent_isStopped(self.anim_close_menu) then
				VC_quitMenu()
				VC_stopSounds()
				
				self.state = MENU_STATE_IDLE
			end
		elseif self.state == MENU_STATE_ANIM_OPEN_SETTINGS then
			if AnimatorComponent_isStopped(self.anim_open_settings) then
				WorldNode_setEnabled(self.main_page, false)
				self.settings_page_script.is_active = true
				
				GUI:focusElement(nil)
				
				self.state = MENU_STATE_IDLE
			end
		elseif self.state == MENU_STATE_ANIM_CLOSE_SETTINGS then
			if AnimatorComponent_isStopped(self.anim_close_settings) then
				WorldNode_setEnabled(self.settings_page, false)
				self.main_page_script.is_active = true
				
				GUI:focusElement(nil)
				
				self.state = MENU_STATE_IDLE
			end
		elseif self.state == MENU_STATE_IDLE then

		end
	end
	
end

function VCMenus:computeBackgroundScreensLayout()

	local layout_index = VC_getCurrentConfiguration()
	computeScreen(self.ntr_tv_screen_top,     layout_index, DISPLAY_TARGET_TV,  DISPLAY_SOURCE_UPPER, 1280, 720, 0, 0, TV_REF_SIZE_X,  TV_REF_SIZE_Y)
	computeScreen(self.ntr_tv_screen_bottom,  layout_index, DISPLAY_TARGET_TV,  DISPLAY_SOURCE_LOWER, 1280, 720, 0, 0, TV_REF_SIZE_X,  TV_REF_SIZE_Y)
	computeScreen(self.ntr_drc_screen_top,    layout_index, DISPLAY_TARGET_DRC, DISPLAY_SOURCE_UPPER, 1280, 720, 0, 0, DRC_REF_SIZE_X, DRC_REF_SIZE_Y)
	computeScreen(self.ntr_drc_screen_bottom, layout_index, DISPLAY_TARGET_DRC, DISPLAY_SOURCE_LOWER, 1280, 720, 0, 0, DRC_REF_SIZE_X, DRC_REF_SIZE_Y)

	computeScreen(self.overlapping_ntr_tv_screen_top,     layout_index, DISPLAY_TARGET_TV,  DISPLAY_SOURCE_UPPER, 1280, 720, 0, 0, TV_REF_SIZE_X,  TV_REF_SIZE_Y)
	computeScreen(self.overlapping_ntr_tv_screen_bottom,  layout_index, DISPLAY_TARGET_TV,  DISPLAY_SOURCE_LOWER, 1280, 720, 0, 0, TV_REF_SIZE_X,  TV_REF_SIZE_Y)
	computeScreen(self.overlapping_ntr_drc_screen_top,    layout_index, DISPLAY_TARGET_DRC, DISPLAY_SOURCE_UPPER, 1280, 720, 0, 0, DRC_REF_SIZE_X, DRC_REF_SIZE_Y)
	computeScreen(self.overlapping_ntr_drc_screen_bottom, layout_index, DISPLAY_TARGET_DRC, DISPLAY_SOURCE_LOWER, 1280, 720, 0, 0, DRC_REF_SIZE_X, DRC_REF_SIZE_Y)

end

function VCMenus:launchAnimation(animator, new_state)

	Component_enable(animator)
	AnimatorComponent_replay(animator)
	
	self.state = new_state
	
	self.main_page_script.is_active = false
	self.settings_page_script.is_active = false
end


-- Switch to page
function VCMenus:switchPage(page)
	
	if page == FIRST_MESSAGE_PAGE then
		
		WorldNode_setEnabled(self.main_page, false)
		WorldNode_setEnabled(self.settings_page, false)
		
		self.current_dialog = createFirstPopupDialog(self, self.popup_first_message)
		
		self.current_dialog.popup_id = POPUP_ID_FIRST_MESSAGE
		
	elseif page == RESTORE_POINT_PAGE then
		
		WorldNode_setEnabled(self.main_page, false)
		WorldNode_setEnabled(self.settings_page, false)
		
		self.current_dialog = createFirstPopupDialog(self, self.popup_load_from_restore_message)
		
		self.current_dialog.popup_id = POPUP_ID_LOAD_FROM_RESTORE_MESSAGE		
		
	elseif page == MAIN_PAGE then
		WorldNode_setEnabled(self.main_page, true)
		
		GUI:focusElement(nil)

		if self.current_page ~= MAIN_PAGE then
			self.main_page_script.is_active = false
			self.settings_page_script.is_active = false
			self:launchAnimation(self.anim_close_settings, MENU_STATE_ANIM_CLOSE_SETTINGS)
		else
			WorldNode_setEnabled(self.settings_page, false)
			
			self.main_page_script.is_active = true
			self.settings_page_script.is_active = false
		end
		
		self.main_page_script:enter()
		
	elseif page == SETTINGS_PAGE then
		--WorldNode_setEnabled(self.main_page, false)
		WorldNode_setEnabled(self.settings_page, true)
		
		GUI:focusElement(nil)

		if self.current_page ~= SETTINGS_PAGE then
			self.main_page_script.is_active = false
			self.settings_page_script.is_active = false

			self:launchAnimation(self.anim_open_settings, MENU_STATE_ANIM_OPEN_SETTINGS)
			
			self.settings_page_script:enter()
		end
	end
	self.current_page = page
end

function VCMenus:onPopupClose(popup, answer)
	if self.current_dialog.popup_id == POPUP_ID_FIRST_MESSAGE or self.current_dialog.popup_id == POPUP_ID_LOAD_FROM_RESTORE_MESSAGE then
		VC_quitMenu()
	end
end

-- Quits the VC menu
function VCMenus:quit()
	self.main_page_script.is_active = false
	self.settings_page_script.is_active = false

	self:launchAnimation(self.anim_close_menu, MENU_STATE_ANIM_CLOSE_MENU)
	VC_playSound(g_menu.sound_close, 1.0)
end

function VCMenus:applyScreensFilteringMode()
	
	local minFilter, magFilter
	if VC_getBilinearMode() == true then
		minFilter = SAMPLING_MINFILTER_LINEAR
		magFilter = SAMPLING_MAGFILTER_LINEAR
	else
		minFilter = SAMPLING_MINFILTER_NEAREST
		magFilter = SAMPLING_MAGFILTER_NEAREST
	end
	
	
	local sprite_component
	
	sprite_component = WorldNode_getComponentByTypeName(self.ntr_tv_screen_top, "sprite")
	VisualComponent_setFilters(sprite_component, minFilter, magFilter)
	sprite_component = WorldNode_getComponentByTypeName(self.ntr_tv_screen_bottom, "sprite")
	VisualComponent_setFilters(sprite_component, minFilter, magFilter)
	sprite_component = WorldNode_getComponentByTypeName(self.ntr_drc_screen_top, "sprite")
	VisualComponent_setFilters(sprite_component, minFilter, magFilter)
	sprite_component = WorldNode_getComponentByTypeName(self.ntr_drc_screen_bottom, "sprite")
	VisualComponent_setFilters(sprite_component, minFilter, magFilter)

end

function VCMenus:applyBackgrounds()
	print("has tv  bg = " .. tostring(VC_hasBgTextureForScreen(0)))
	print("has drc bg = " .. tostring(VC_hasBgTextureForScreen(1)))

	WorldNode_setEnabled(self.ntr_tv_screen_bg, VC_hasBgTextureForScreen(0))
	WorldNode_setEnabled(self.ntr_drc_screen_bg, VC_hasBgTextureForScreen(1))
	
	VC_replaceTexture(self.top_bg_texture, 4)
	VC_replaceTexture(self.bottom_bg_texture, 5)
end


function openManual()
	local manual_url
	
	if titleId == "title_id_to_change" then
		manual_url = "http://m1.nintendo.net/docvc/NTR/JPN/AYIJ/AYIJ_J.pdf"
	else
		local language = VC_getPlatformLanguage()
		local language_suffix = ""
	
		if language == LANGUAGE_JAPANESE then
			language_suffix = "J"
		elseif language == LANGUAGE_ENGLISH then
			language_suffix = "E"
		elseif language == LANGUAGE_FRENCH then
			language_suffix = "F"
		elseif language == LANGUAGE_GERMAN then
			language_suffix = "G"
		elseif language == LANGUAGE_ITALIAN then
			language_suffix = "I"
		elseif language == LANGUAGE_SPANISH then
			language_suffix = "S"
		elseif language == LANGUAGE_DUTCH then
			language_suffix = "D"
		elseif language == LANGUAGE_PORTUGUESE then
			language_suffix = "P"
		elseif language == LANGUAGE_RUSSIAN then
			language_suffix = "R"
		end
		
		if not manual_languages[language_suffix] then
			language_suffix = default_language
		end
		
		manual_url = "https://m1.nintendo.net/docvc/" .. platformId .. "/" .. regionId .. "/" .. titleId .."/" .. titleId .. "_" .. language_suffix .. ".pdf"
	end

	--print('opening manual '..manual_url)
	VC_openBrowser(manual_url)
end

function VCMenus:fadeOut()

	WorldNode_setEnabled(self.occulting_sprite, true)
	AnimatorComponent_setSpeed(self.anim_menu_fadeout, 1)
	AnimatorComponent_replay(self.anim_menu_fadeout)

end

function VCMenus:fadeIn()

	WorldNode_setEnabled(self.occulting_sprite, true)
	AnimatorComponent_setSpeed(g_menu.anim_menu_fadeout, -1)
	AnimatorComponent_replay(self.anim_menu_fadeout)

end

function VCMenus:fadeCompleted()
	return AnimatorComponent_isStopped(self.anim_menu_fadeout)
end

function VCMenus:stopFade()
	WorldNode_setEnabled(self.occulting_sprite, false)
end