require 'scripts/gui/gui_button.lua'

VCButton = class(GUIButton)


VCButton.states = class(GUIButton.states)
VCButton.states.pressed = class(GUIButton.states.pressed)

VCButton.states.pressed.enter = function(element, previousState)
	
	GUIButton.states.pressed.enter(element, previousState)
	
	if g_menu.focusedElementAtFrameStart == element then
		if element.pressedAnimation ~= nil then
			Component_disable(element.pressedAnimation)
			AnimatorComponent_setSpeed(element.pressedAnimation, -1)
			AnimatorComponent_reset(element.pressedAnimation)
		end
		if element.focusedAnimation ~= nil then
			Component_disable(element.focusedAnimation)
		end
	end
end

VCButton.states.pressed.leave = function(element, previousState)
	
	if element.pressedAnimation ~= nil then
			Component_enable(element.pressedAnimation)
	end
	
	GUIButton.states.pressed.leave(element, previousState)
end