-- Simulate VC menu specific bound functions when using generic reed player
if not VC_hasState then
	print("using reedplayer")
	
	isFirstLaunch = false
	
	VC_isFirstLaunch = function()
		local b = isFirstLaunch
		isFirstLaunch = false
		return b
	end
	
	isLaunchedFromRestorePoint = false
	
	VC_isLaunchedFromRestorePoint = function()
		local b = isLaunchedFromRestorePoint
		isLaunchedFromRestorePoint = false
		return b
	end
	
	
	VC_hasState = function()
		return true
	end
	
	VC_saveState = function()
	end
	
	VC_restoreState = function()
	end
	
	VC_getSaveStateDate = function()
		return 2014, 07, 17, 12, 12, 12
	end

	VC_reset = function()
	end
	
	VC_quitMenu = function()
	end
	
	VC_getPlatformLanguage = function()
		return 0
	end
	
	VC_openBrowser = function(url)
		print("open url : "..url)
	end
	
	VC_hasBgTextureForScreen = function(id)
		return false
	end
	
	VC_replaceTexture = function(resource, screen)
	end
	
	bilinear = true

	VC_getBilinearMode = function()
		return bilinear
	end
	
	VC_setBilinearMode = function(b)
		bilinear = b
	end
	
	g_currentConfig = 0
	g_screenConfigCount = 8
	g_groupCount = 5
	
	VC_getCurrentConfiguration = function()
		return g_currentConfig + 1
	end
	
	VC_setCurrentConfiguration = function(new_config)
		g_currentConfig = (new_config - 1) % g_screenConfigCount
	end
	
	VC_switchToPreviousConfiguration = function()
		g_currentConfig = (g_currentConfig + (g_screenConfigCount - 1)) % g_screenConfigCount
	end
	
	VC_switchToNextConfiguration = function()
		g_currentConfig = (g_currentConfig + 1) % g_screenConfigCount
	end
	
	VC_getScreenConfigurationName = function(config_index)
		layouts_name = { 
			"VCM_LAYOUT_1_NAME",
			"VCM_LAYOUT_2_NAME",
			"VCM_LAYOUT_3_NAME",
			"VCM_LAYOUT_4_NAME",
			"VCM_LAYOUT_5_NAME",
			"VCM_LAYOUT_6_NAME",
			"VCM_LAYOUT_7_NAME",
			"VCM_LAYOUT_8_NAME"
		}

		return layouts_name[config_index]
	end
	
	VC_getScreenConfigurationDesc = function(config_index)
		layouts_desc = { 
			"VCM_LAYOUT_1_EXPLANATION",
			"VCM_LAYOUT_2_EXPLANATION",
			"VCM_LAYOUT_3_EXPLANATION",
			"VCM_LAYOUT_4_EXPLANATION",
			"VCM_LAYOUT_5_EXPLANATION",
			"VCM_LAYOUT_6_EXPLANATION",
			"VCM_LAYOUT_7_EXPLANATION",
			"VCM_LAYOUT_8_EXPLANATION"
		}

		return layouts_desc[config_index]
	end
	
	VC_getScreenConfigurationCount = function()
		return g_screenConfigCount
	end
	
	VC_getLayoutGroupCount = function()
		return g_groupCount
	end
	
	VC_getLayoutGroupConfigCount = function(layout_index)
		
		local layout_group_alt_count = {
			1,
			2,
			2,
			2,
			1
		}
		return layout_group_alt_count[layout_index]
	end
	
	VC_getScreenMarginSize = function()
		return 0, 0
	end
	
	VC_getScreenDrcRotation = function(layout_index)
		
		local rotations = {
			0, 0, 0, 270, 90, 0, 0, 0
			}
		return rotations[layout_index]
	end
	
	VC_getScreenLayoutPosition = function()
		return 0, 0
	end
	
	VC_getScreenLayoutSize = function()
		return 0, 0
	end
	
	VC_getScreenLayoutBackgroundName = function(layout_index, target_index)
		return ""
	end
	
	VC_getScreenLayoutRotation = function()
		return 0
	end
	
	VC_isScreenLayoutInitialized = function()
		return false
	end
	
	VC_isScreenConfigurationPixelPerfect = function(layout_index)
		return layout_index == 1
	end
	
	VC_playSound = function(sound)
		
	end
	
	VC_stopSounds = function()
	end
	
	
	GAMEPAD_LEFT_ZTRIGGER = GAMEPAD_LEFT_TRIGGER
	GAMEPAD_RIGHT_ZTRIGGER = GAMEPAD_RIGHT_TRIGGER
	
	GAMEPAD_RIGHT_STICK = GAMEPAD_Y
	
	GAMEPAD_RAXIS_X = GAMEPAD_AXIS_X
	GAMEPAD_RAXIS_Y = GAMEPAD_AXIS_Y
	
end
