
VERTICAL_HOLDING_SCALE = 1.56


function getScreenshotsRotation()
	local layout = VC_getCurrentConfiguration()
	return VC_getScreenLayoutRotation(layout, DISPLAY_TARGET_TV, DISPLAY_SOURCE_UPPER)
end

function createFirstPopupDialog(listener, prefab)
	local dialogNode = Scene_instantiate(prefab)
	WorldNodeManager_addHierarchyToWorld(dialogNode)
	
	local dialogScript = WorldNode_getScriptComponent(dialogNode, "VCPopup")
	
	if dialogScript == nil then
		print("Not a VCPopup : aborting")
		return nil
	end
	dialogScript.listener = listener

	
	return dialogScript
end

function createPopupDialog(listener, prefab, title, message)
	local dialogNode = Scene_instantiate(prefab)
	WorldNodeManager_addHierarchyToWorld(dialogNode)

	local dialogScript = WorldNode_getScriptComponent(dialogNode, "VCPopup")
	
	if dialogScript == nil then
		print("Not a VCPopup : aborting")
		return nil
	end

	dialogScript.listener = listener
	
	LabelComponent_setTextFromStringId(dialogScript.title, title)
	LabelComponent_setTextFromStringId(dialogScript.message, message)
	
	if verticalHolding and dialogScript.screenshots_node then
		
		local angle = getScreenshotsRotation()
		local scale = 1
		
		if (angle % 180) == 90 then
			scale = VERTICAL_HOLDING_SCALE
		end
		
		WorldNode_setLocalRotation(dialogScript.screenshots_node, math.rad(angle))
		WorldNode_setLocalScale(dialogScript.screenshots_node, scale, scale)
	end
	
	return dialogScript
end