require 'scripts/gui/gui_popup.lua'
--------------------------------------------------------------------------------
-- VCPopup Object script
--------------------------------------------------------------------------------

POPUP_STATE_IDLE = 0
POPUP_STATE_ANIM_OPEN = 1
POPUP_STATE_ANIM_CLOSE = 2

VCPopup = class(GUIPopup)


-- Callback when object is added to the world
function VCPopup:start()
	print('VCPopup:start()')
	
	GUIPopup.start(self)
	
	self.validate_button = self.ok_button or self.yes_button
	self.invalidate_button = self.cancel_button or self.no_button
	
	if self.anim_open then
		self.state = POPUP_STATE_ANIM_OPEN
	
		self.current_animation = self.anim_open
		Component_enable(self.current_animation)
		AnimatorComponent_play(self.current_animation)
		self:disable()
	else
		self.state = POPUP_STATE_IDLE
		
		self.enable()
	end
	
	if not self.anim_close_cancel then
		self.anim_close_cancel = self.anim_close
	end

	VC_playSound(g_menu.sound_popup_open, 1.0)
	
end

function VCPopup:close(userChoice)
	
	GUI:debugPrint("User closed with " .. tostring(userChoice))
	
	self.userChoice = userChoice
	
	GUI:focusElement(nil)
	
	Component_disable(self.anim_open)
	
	local anim_close = nil
	if userChoice == "ok" or userChoice == "yes" then
		anim_close = self.anim_close
		VC_playSound(g_menu.sound_popup_ok, 1.0)
	else
		anim_close = self.anim_close_cancel
		VC_playSound(g_menu.sound_popup_cancel, 1.0)
	end
	
	Component_enable(anim_close)
	AnimatorComponent_play(anim_close)
	self:disable()

	self.current_animation = anim_close
	
	self.state = POPUP_STATE_ANIM_CLOSE
end

function VCPopup:onElementFocus(element)
	VC_playSound(g_menu.sound_select, 1.0)
end

function VCPopup:onButtonPress(button)
	VC_playSound(g_menu.sound_select, 1.0)
end

-- Callback called every frames
function VCPopup:update(dt)
	if self.state == POPUP_STATE_ANIM_OPEN then
		if AnimatorComponent_isStopped(self.current_animation) then
			self.current_animation = nil
			self:enable()
			self.state = POPUP_STATE_IDLE
		end
	elseif self.state == POPUP_STATE_ANIM_CLOSE then
		if AnimatorComponent_isStopped(self.current_animation) then
			GUIPopup.close(self, self.userChoice)
			WorldNode_destroy(self.worldNode)
			
			self.current_animation = nil
		end
	elseif self.state == POPUP_STATE_IDLE then
	
		if GUI.pressedCommandTarget == nil then -- disable keys when a touch button is pressed
			
			if GUI:isLeftPressed() or GUI:isRightPressed() or GUI:isUpPressed() or GUI:isDownPressed() then
			
				if self.invalidate_button then
					if GUI:isLeftPressed() then
						GUI:focusElement(self.invalidate_button)
					elseif GUI:isRightPressed() then
						GUI:focusElement(self.validate_button)
					end
				else
					GUI:focusElement(self.validate_button)
				end
				
			elseif GUI:isCancelPressed() then
				
				local isValidateButtonFocused = GUI.focusedElement ~= nil and GUI.focusedElement == self.validate_button
						
				if isValidateButtonFocused and self.invalidate_button then
					GUI:focusElement(self.invalidate_button)
				else
					Input_freeze()
					
					if self.invalidate_button then
						self:close("cancel")
					else
						self:close("ok")
					end
					
					GUI:focusElement(nil)
					
					if self.invalidate_button then
						self.invalidate_button:playClickedAnimation()
					elseif self.validate_button then
						self.validate_button:playClickedAnimation()
					end
					
					VC_playSound(g_menu.sound_select, 1.0)
				end
				
			elseif GUI.focusedElement == nil and GUI:isValidatePressed() then
				
				Input_freeze()
				GUI:focusElement(nil)
				self:close("ok")
				if self.validate_button then
					self.validate_button:playClickedAnimation()
				end
				VC_playSound(g_menu.sound_select, 1.0)
			end
		end
	end
	
end