require 'scripts/gui/gui.lua'

-- Popups ids
POPUP_ID_NONE = 0
POPUP_ID_CREATE_POINT = 1
POPUP_ID_CREATE_POINT_SUCCESS = 2
POPUP_ID_RESET = 3
POPUP_ID_LOAD_POINT = 4
POPUP_ID_LOAD_POINT_SUCCESS = 5

--------------------------------------------------------------------------------
-- MainPage Object script
--------------------------------------------------------------------------------

-- constants
MAINPAGE_STATE_IDLE = 0
MAINPAGE_STATE_ANIM = 1
MAINPAGE_STATE_FADEOUT_TO_MANUAL = 2
MAINPAGE_STATE_START_FADEIN_FROM_MANUAL = 3
MAINPAGE_STATE_FADEIN_FROM_MANUAL = 4
MAINPAGE_STATE_NOT_ACTIVE = 5

MainPage = class()

-- Callback when object is added to the world
function MainPage:start()
	self.current_dialog = nil
	self.state = 0
	
	-- self.create_button = ScriptComponent_getScriptTable(self.create_button)
	-- self.load_button = ScriptComponent_getScriptTable(self.load_button)
	-- self.reset_button = ScriptComponent_getScriptTable(self.reset_button)
	-- self.settings_button = ScriptComponent_getScriptTable(self.settings_button)
	-- self.manual_button = ScriptComponent_getScriptTable(self.manual_button)
	-- self.back_button = ScriptComponent_getScriptTable(self.back_button)

	self.has_state = VC_hasState()

	if not self.has_state then
		self.load_button:setState("disabled")
		WorldNode_setEnabled(self.screenshots_load_node, false)
	else 
		self.load_button:setState("idle")
		WorldNode_setEnabled(self.screenshots_load_node, true)
	end
	
	GUI:focusElement(nil)
	
	self.state = MAINPAGE_STATE_IDLE
	self.animation_controller = nil
	
	self.is_active = true
	
end

function MainPage:enter()
	
	if verticalHolding then
		local rotation = math.rad(getScreenshotsRotation())
		WorldNode_setLocalRotation(self.screenshots_load_node, rotation)
		WorldNode_setLocalRotation(self.screenshots_save_node, rotation)
	end
	
	self.state = MAINPAGE_STATE_NOT_ACTIVE
	self:enableClickables(false)
end

-- Callback called every frames
function MainPage:update(dt)
	
	if not self.is_active then
		return
	end
	
	if self.state == MAINPAGE_STATE_NOT_ACTIVE then
		
			self.state = MAINPAGE_STATE_IDLE
			self:enableClickables(true)
	
	elseif self.state == MAINPAGE_STATE_IDLE then
		if self.current_dialog == nil and GUI.pressedCommandTarget == nil then
			if GUI:isLeftPressed() then
				if GUI.focusedElement ~= self.create_button then
					GUI:focusElement(self.create_button)
				end
			elseif GUI:isRightPressed() then
				if self.has_state and GUI.focusedElement ~= self.load_button then
					GUI:focusElement(self.load_button)
				end
				--else
				--	GUI:focusElement(nil)
				--end
			elseif GUI:isUpPressed() then
				if GUI.focusedElement ~= self.reset_button then
					GUI:focusElement(self.reset_button)
				end
			elseif GUI:isDownPressed() then
				if GUI.focusedElement ~= self.settings_button then
					GUI:focusElement(self.settings_button)
				end
			elseif GUI:isKeyPressed(PAD_DEVICE, GAMEPAD_LEFT_ZTRIGGER, 0) then

				self:enableClickables(false)
				VC_playSound(g_menu.sound_popup_open, 1.0)
				
				self.manual_button:setState("pressed")
				g_menu:fadeOut()
				self.state = MAINPAGE_STATE_FADEOUT_TO_MANUAL
				
			elseif GUI:isKeyPressed(PAD_DEVICE, GAMEPAD_B, 0) or GUI:isKeyPressed(PAD_DEVICE, GAMEPAD_RIGHT_ZTRIGGER, 0) then
				self:enableClickables(false)
				self.back_button:playClickedAnimation()
				VC_playSound(g_menu.sound_select, 1.0)
				g_menu:quit()
			end
		end
	elseif self.state == MAINPAGE_STATE_FADEOUT_TO_MANUAL then
		if g_menu:fadeCompleted() then
			openManual()
			self.state = MAINPAGE_STATE_START_FADEIN_FROM_MANUAL
			
		end
	elseif self.state == MAINPAGE_STATE_START_FADEIN_FROM_MANUAL then
		self.state = MAINPAGE_STATE_FADEIN_FROM_MANUAL
		g_menu:fadeIn()
		self.manual_button:setState("idle")
	elseif self.state == MAINPAGE_STATE_FADEIN_FROM_MANUAL then
		if g_menu:fadeCompleted() then
			self.state = MAINPAGE_STATE_IDLE
			g_menu:stopFade()
			self:enableClickables(true)
		end
	else
		if AnimatorComponent_isStopped(self.animation_controller) then
			
			self.state = MAINPAGE_STATE_IDLE
			self.animation_controller = nil
			self:enableClickables(true)
		end
		
	end
end

function MainPage:onElementFocus(element)
	VC_playSound(g_menu.sound_select, 1.0)
end

-- Callback when object is a button and is pressed
function MainPage:onButtonClick(button)
	
	if not self.is_active then
		return
	end
	
	if self.state == MAINPAGE_STATE_IDLE and self.current_dialog == nil then
		
		-- RESET
		if button == self.reset_button then
			
			self:enableClickables(false)
			self.current_dialog = createPopupDialog(self, self.popup_message_2_buttons2, "VCM_DIALOG_RESET_GUIDE", "VCM_DIALOG_RESET_NOTICE")
			self.current_dialog.popup_id = POPUP_ID_RESET
			
		-- LOAD RESTORE POINT
		elseif button == self.load_button then
		
			self:enableClickables(false)
			
			if useSRAM then
				self.current_dialog = createPopupDialog(self, self.popup_load_restorepoint , "VCM_DIALOG_LOAD_TITLE", "VCM_DIALOG_LOAD_NOTICE_WITH_SRAM")
			else
				self.current_dialog = createPopupDialog(self, self.popup_load_restorepoint , "VCM_DIALOG_LOAD_TITLE", "VCM_DIALOG_LOAD_NOTICE")
			end
			LabelComponent_setTextFromStringId(self.current_dialog.message2, "VCM_DIALOG_LOAD_GUIDE")
			
			self.current_dialog.popup_id = POPUP_ID_LOAD_POINT
			
		-- CREATE RESTORE POINT
		elseif button == self.create_button then
			
			self:enableClickables(false)
			
			local saveGuideTextId = useSRAM and "VCM_DIALOG_SAVE_GUIDE_WITH_SRAM" or "VCM_DIALOG_SAVE_GUIDE"
			
			if not self.has_state then
				self.current_dialog = createPopupDialog(self, self.popup_save_restorepoint, "VCM_DIALOG_SAVE_TITLE", saveGuideTextId)
			else
				self.current_dialog = createPopupDialog(self, self.popup_save_restorepoint_exist, "VCM_DIALOG_SAVE_TITLE", "VCM_DIALOG_SAVE_NOTICE")
				LabelComponent_setTextFromStringId(self.current_dialog.message2, saveGuideTextId)
			end

			self.current_dialog.popup_id = POPUP_ID_CREATE_POINT
			
		-- SETTINGS
		elseif button == self.settings_button then
			
			self:enableClickables(false)
			g_menu:switchPage(SETTINGS_PAGE)
			
			VC_playSound(g_menu.sound_popup_open, 1.0)
			
		-- MANUAL
		elseif button == self.manual_button then
			
			self:enableClickables(false)
			g_menu:fadeOut()
			
			VC_playSound(g_menu.sound_popup_open, 1.0)
			
			self.state = MAINPAGE_STATE_FADEOUT_TO_MANUAL

		-- CLOSE
		elseif button == self.back_button then
			
			self:enableClickables(false)
			g_menu:quit()
		end
	end

end

function MainPage:onButtonPress(button)
	
	if self.is_active then
		VC_playSound(g_menu.sound_select, 1.0)
	end
	
end

-- Callback when object is a button and is released
function MainPage:onPopupClose(popup, answer)

	if answer == "ok" or answer == "yes" then
		if self.current_dialog.popup_id == POPUP_ID_CREATE_POINT then

			VC_saveState()

			self.current_dialog = createPopupDialog(self, self.popup_save_success, "VCM_DIALOG_SAVE_TITLE", "VCM_DIALOG_SAVE_FINISH")

			self.current_dialog.popup_id = POPUP_ID_CREATE_POINT_SUCCESS
		elseif self.current_dialog.popup_id == POPUP_ID_LOAD_POINT then
			
			VC_restoreState()
			
			self.isRestored = true
			
			self.current_dialog = createPopupDialog(self, self.popup_1_button, "VCM_DIALOG_LOAD_TITLE", "VCM_DIALOG_LOAD_FINISH")

			VC_replaceTexture(g_menu.place_holder_top, 2)
			VC_replaceTexture(g_menu.place_holder_bottom, 3)

			self.current_dialog.popup_id = POPUP_ID_LOAD_POINT_SUCCESS
			
		elseif self.current_dialog.popup_id == POPUP_ID_CREATE_POINT_SUCCESS then
			
			self.current_dialog = nil

			if not self.isRestored then
				VC_replaceTexture(g_menu.save_placeholder_top, 0)
				VC_replaceTexture(g_menu.save_placeholder_bottom, 1)
			end
			
			self.has_state = true
			self.load_button:setState("idle")
			WorldNode_setEnabled(self.screenshots_load_node, true)
			
			local year, month, day, hour, minute, second = VC_getSaveStateDate()

			TextVariableManager_setIntVariable("FILE_YEAR", year)
			TextVariableManager_setIntVariable("FILE_MONTH", month)
			TextVariableManager_setIntVariable("FILE_DAY", day)
			TextVariableManager_setIntVariable("FILE_HOUR", hour)
			TextVariableManager_setIntVariable("FILE_MINUTE", minute)
			
		elseif self.current_dialog.popup_id == POPUP_ID_LOAD_POINT_SUCCESS then

			self.current_dialog = nil

		elseif self.current_dialog.popup_id == POPUP_ID_RESET then

			VC_reset()
			g_menu:quit()
			
			self.current_dialog = nil

		end
	else
		self.current_dialog = nil
	end
	
	if self.current_dialog == nil then
		self:enableClickables(true)
	end
end

function MainPage:enableClickables(enable)
	
	Component_setEnabled(self.reset_button.clickable, enable)
	Component_setEnabled(self.load_button.clickable, enable)
	Component_setEnabled(self.create_button.clickable, enable)
	Component_setEnabled(self.settings_button.clickable, enable)
	Component_setEnabled(self.manual_button.clickable, enable)
	Component_setEnabled(self.back_button.clickable, enable)
end
