
-- Converts a group index and its alternative index to a linear index
function getLinearIndexFromGroupAndAlt(group, alt)
	
	local linear_index = 1
	
	for i = 1, group - 1 do
		linear_index = linear_index + VC_getLayoutGroupConfigCount(i)
	end
	
	linear_index = linear_index + alt - 1
	
	return linear_index
end

-- Converts a linear index to a group index and its alternative index
function getGroupAndAltFromLinearIndex(index)
	
	local group = 1
	local alt = 1
	local i = 1
	
	-- for i = 1, #layout_group_alt_count do
	while index > VC_getLayoutGroupConfigCount(i) do
		
		index = index - VC_getLayoutGroupConfigCount(i)
		group = group + 1

		i = i + 1
	end
	
	alt = index
	
	return group, alt
	
end



TV_REF_SIZE_X = 1280
TV_REF_SIZE_Y = 720
DRC_REF_SIZE_X = 854
DRC_REF_SIZE_Y = 480


function computeScreen(screen_node, layout_index, target_index, source_index, target_sizeX, target_sizeY, offset_x, offset_y, ref_sizeX, ref_sizeY)
	
	local initialized = VC_isScreenLayoutInitialized(layout_index, target_index, source_index)
	WorldNode_setEnabled(screen_node, initialized)
	
	local rotation = VC_getScreenLayoutRotation(layout_index, target_index, source_index)
	
	local sizeX, sizeY = VC_getScreenLayoutSize(layout_index, target_index, source_index)
	
	local adjustedSizeX = sizeX / ref_sizeX * target_sizeX
	local adjustedSizeY = sizeY / ref_sizeY * target_sizeY

	local posX, posY = VC_getScreenLayoutPosition(layout_index, target_index, source_index)
	
	local adjustedPosX = posX / ref_sizeX * target_sizeX - target_sizeX / 2
	local adjustedPosY = -posY / ref_sizeY * target_sizeY + target_sizeY / 2
	adjustedPosX = adjustedPosX + adjustedSizeX / 2 + offset_x
	adjustedPosY = adjustedPosY - adjustedSizeY / 2 + offset_y
	
	-- if initialized then
	-- 	print("rotation = "..rotation .. " pos = " .. posX .. "," .. posY .. "=>" .. adjustedPosX .. "," .. adjustedPosY .. "\t\tsize = "..sizeX..","..sizeY.."=>"..adjustedSizeX..","..adjustedSizeY)
	-- else
	-- 	print("not enabled")
	-- end
	
	
	WorldNode_setLocalPosition(screen_node, adjustedPosX, adjustedPosY)
	
	WorldNode_setLocalRotation(screen_node, math.rad(rotation))
	
	local sprite_component = WorldNode_getComponentByTypeName(screen_node, "sprite")
	
	if rotation == 90 or rotation == 270 then
		SimpleSpriteComponent_setSize(sprite_component, adjustedSizeY, adjustedSizeX)
	else
		SimpleSpriteComponent_setSize(sprite_component, adjustedSizeX, adjustedSizeY)
	end
	
	-- PATCH to recompute transform that counter balance pivot in the center of the sprite
	SimpleSpriteComponent_setAnchor(sprite_component, 0, 0)
	
	--print("pos = " .. adjustedPosX .. "," .. adjustedPosY)
	
end